package ru.yandex.solomon.gateway.www.ser;

import java.time.Duration;
import java.util.Optional;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.util.www.ser.WwwDurationSerializer;

/**
 * @author Stepan Koltsov
 */
public class WwwDurationSerializerTest {

    private void testParseDuratation(Duration expected, String string) {
        Assert.assertEquals(Optional.of(expected), WwwDurationSerializer.parseDuration(string));
    }

    @Test
    public void parseDuration() {
        Assert.assertEquals(Optional.<Duration>empty(), WwwDurationSerializer.parseDuration(""));
        Assert.assertEquals(Optional.<Duration>empty(), WwwDurationSerializer.parseDuration("aabb"));
        testParseDuratation(Duration.ofHours(17), "17h");
        testParseDuratation(Duration.ofMinutes(90), "1h30m");
        testParseDuratation(Duration.ofDays(2), "2d");
        testParseDuratation(Duration.ofDays(21), "3w");
        testParseDuratation(Duration.ofDays(22), "3w1d");
    }

}
