package ru.yandex.solomon.gateway.www.time;

import java.time.Duration;
import java.time.Instant;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class UiInstantTest {

    @Test
    public void isBefore() {
        Assert.assertTrue(UiInstant.relativeBackwards(Duration.ofHours(2))
                .isBefore(UiInstant.relativeBackwards(Duration.ofHours(1))));
        Assert.assertFalse(UiInstant.instant(Instant.parse("2015-07-07T12:13:14Z"))
                .isBefore(UiInstant.relativeBackwards(Duration.ofHours(1))));
        Assert.assertFalse(UiInstant.relativeBackwards(Duration.ofHours(1))
                .isBefore(UiInstant.instant(Instant.parse("2015-07-07T12:13:14Z"))));
        Assert.assertTrue(UiInstant.instant(Instant.parse("2015-07-07T12:13:10Z"))
                .isBefore(UiInstant.instant(Instant.parse("2015-07-07T12:13:14Z"))));
        Assert.assertFalse(UiInstant.instant(Instant.parse("2015-07-07T12:13:14Z"))
                .isBefore(UiInstant.instant(Instant.parse("2015-07-07T12:13:10Z"))));
    }

}
