JAVA_PROGRAM(gateway)

OWNER(g:solomon)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/jdk.inc)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.solomon.gateway
    SRCDIR src
    **/*.java
    **/*.json
    **/*.yql
    **/*.txt
)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/contribs.inc)

PEERDIR(
    # spring
    contrib/java/org/springframework/spring-aop
    contrib/java/org/springframework/spring-beans
    contrib/java/org/springframework/spring-context
    contrib/java/org/springframework/spring-core
    contrib/java/org/springframework/spring-expression
    contrib/java/org/springframework/spring-web

    contrib/java/com/google/protobuf/protobuf-java-util

    # solomon deps
    solomon/libs/java/idempotency
    solomon/libs/java/auth
    solomon/libs/java/auth-context
    solomon/libs/java/conf-db
    solomon/libs/java/conf-db3
    solomon/libs/java/acl-db
    solomon/libs/java/coremon-client
    solomon/libs/java/dataproxy-client
    solomon/libs/java/expression
    solomon/libs/java/http-filters
    solomon/libs/java/grpc-handler
    solomon/libs/java/main
    solomon/libs/java/metrics-client
    solomon/libs/java/metrics-parser
    solomon/libs/java/name-resolver-client
    solomon/libs/java/operation
    solomon/libs/java/quotas-manager
    solomon/libs/java/roles-context
    solomon/libs/java/service-ctx
    solomon/libs/java/tracing
    solomon/libs/java/util
    solomon/libs/java/yandex/abc
    solomon/libs/java/yandex/abc-context
    solomon/libs/java/yandex/staff
    solomon/libs/java/yandex/idm
    solomon/libs/java/distributed-scheduler
    solomon/libs/java/grpc-conf
    solomon/protos/agent
    solomon/protos/gateway
    solomon/protos/api/v3
    solomon/protos/api/v3/priv
    solomon/protos/monitoring/v3
    solomon/protos/monitoring/v3/cloud
    solomon/protos/monitoring/v3/cloud/priv
    solomon/protos/monitoring/v3/priv
    solomon/services/gateway/alerting
    solomon/services/gateway/api
    solomon/services/gateway/cloud

    yt/java/ytclient
    iceberg/misc-async-http-client-2

    # cloud deps
    cloud/bitbucket/public-api/yandex/cloud/monitoring/v3
    cloud/bitbucket/private-api/yandex/cloud/priv/monitoring/v2
    cloud/bitbucket/private-api/yandex/cloud/priv/monitoring/v3

    # 3rd-party deps
    contrib/java/io/netty/netty-all
    contrib/java/com/google/guava/guava

    # swagger
    contrib/java/io/springfox/springfox-swagger2
    contrib/java/io/springfox/springfox-swagger-ui
    contrib/java/com/fasterxml/classmate/1.3.3

    contrib/java/javax/annotation/javax.annotation-api
)

EXCLUDE(
    ${service_excludes}
)

LINT(base)
END()

RECURSE_FOR_TESTS(
    conftest
    ut
)
