package ru.yandex.solomon.gateway.cloud.api;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;

import ru.yandex.solomon.common.RequestProducer;

/**
 * @author Vladimir Gordiychuk
 */
public class RequestProducerInterceptor implements ServerInterceptor {
    private static final Metadata.Key<String> UI_REQUEST_HEADER_KEY =
        Metadata.Key.of("x-ui-request", Metadata.ASCII_STRING_MARSHALLER);

    private static final Context.Key<RequestProducer> REQUEST_PRODUCER_KEY = Context.key("UIRequest");

    private RequestProducerResolver producerResolver;

    public RequestProducerInterceptor(RequestProducerResolver producerResolver) {
        this.producerResolver = producerResolver;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(
        ServerCall<ReqT, RespT> call,
        Metadata headers,
        ServerCallHandler<ReqT, RespT> next)
    {
        String header = headers.get(UI_REQUEST_HEADER_KEY);
        var producer = producerResolver.resolve(header);

        Context context = Context.current()
            .withValue(REQUEST_PRODUCER_KEY, producer);

        return Contexts.interceptCall(context, call, headers, next);
    }
}
