package ru.yandex.solomon.gateway.cloud.billing;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.util.collection.enums.EnumMapToAtomicLong;

/**
 * @author Vladimir Gordiychuk
 */
public class BillingLogStub implements BillingLog {
    private ConcurrentMap<Key, Usage> usages = new ConcurrentHashMap<>();

    @Override
    public void writePoints(String cloudId, String folderId, MetricType type, long count, long startSec, long finishSec) {
        getUsage(cloudId, folderId).write.addAndGet(type, count);
    }

    @Override
    public void readPoints(String cloudId, String folderId, MetricType type, long count, long startSec, long finishSec) {
        getUsage(cloudId, folderId).read.addAndGet(type, count);
    }

    @Override
    public void storePoints(String cloudId, String folderId, MetricType type, long count, long startSec, long finishSec) {
        getUsage(cloudId, folderId).store.addAndGet(type, count);
    }

    private Usage getUsage(String cloudId, String folderId) {
        return usages.computeIfAbsent(new Key(cloudId, folderId), ignore -> new Usage());
    }

    public long reads(String cloudId, String folderId, MetricType type) {
        return getUsage(cloudId, folderId).read.get(type);
    }

    private static class Key extends DefaultObject {
        private final String cloudId;
        private final String folderId;

        public Key(String cloudId, String folderId) {
            this.cloudId = cloudId;
            this.folderId = folderId;
        }
    }

    private static class Usage {
        private EnumMapToAtomicLong<MetricType> write = new EnumMapToAtomicLong<>(MetricType.class);
        private EnumMapToAtomicLong<MetricType> read = new EnumMapToAtomicLong<>(MetricType.class);
        private EnumMapToAtomicLong<MetricType> store = new EnumMapToAtomicLong<>(MetricType.class);
    }
}
