package ru.yandex.solomon.gateway.cloud.billing;

import java.util.function.IntPredicate;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class BillingShardFilter implements IntPredicate {
    private final ShardByNumIdResolver resolver;

    public BillingShardFilter(ShardByNumIdResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public boolean test(int numId) {
        var shard = resolver.resolve(numId);
        if (shard == null) {
            return false;
        }

        // TODO: use billable flag instead
        return "custom".equals(shard.getServiceName());
    }
}
