package ru.yandex.solomon.gateway.cloud.billing;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import ru.yandex.solomon.gateway.cloud.billing.stockpile.StockpileUsage;
import ru.yandex.solomon.util.time.Interval;

import static java.util.concurrent.CompletableFuture.completedFuture;
import static java.util.concurrent.CompletableFuture.failedFuture;

/**
 * @author Vladimir Gordiychuk
 */
public class LogBillingEndpoint implements BillingEndpoint {
    private final ShardByNumIdResolver shardResolver;
    private final BillingLog log;

    public LogBillingEndpoint(ShardByNumIdResolver shardResolver, BillingLog log) {
        this.shardResolver = shardResolver;
        this.log = log;
    }

    @Override
    public CompletableFuture<Void> push(StockpileUsage usage, Interval interval, long leaderSeqNo) {
        try {
            int startSec = (int) TimeUnit.MILLISECONDS.toSeconds(interval.getBeginMillis());
            int finishSec = (int) TimeUnit.MILLISECONDS.toSeconds(interval.getEndMillis());
            for (var entry : usage.usageByKey.long2ObjectEntrySet()) {
                var key = entry.getLongKey();
                var value = entry.getValue();
                var numId = StockpileUsage.ownerShardId(key);
                var type = StockpileUsage.type(key);
                var shard = shardResolver.resolve(numId);
                if (shard == null) {
                    continue;
                }

                var cloudId = shard.getProjectId();
                var folderId = shard.getClusterName();
                log.writePoints(cloudId, folderId, type, value.writeRecords, startSec, finishSec);
                log.readPoints(cloudId, folderId, type, value.readRecords, startSec, finishSec);
                log.storePoints(cloudId, folderId, type, value.storeRecords, startSec, finishSec);
            }
            return completedFuture(null);
        } catch (Throwable e) {
            return failedFuture(e);
        }
    }
}
