package ru.yandex.solomon.gateway.cloud.billing;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.conf.ShardConfMaybeWrong;
import ru.yandex.solomon.core.conf.SolomonConfWithContext;
import ru.yandex.solomon.core.conf.watch.SolomonConfListener;
import ru.yandex.solomon.core.db.model.Shard;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ShardByNumIdResolverImpl implements ShardByNumIdResolver, SolomonConfListener {
    @Nullable
    private volatile SolomonConfWithContext context;

    @Nullable
    @Override
    public Shard resolve(int numId) {
        var contextCopy = context;
        if (contextCopy == null) {
            return null;
        }

        ShardConfMaybeWrong conf = contextCopy.getShardByNumIdOrNull(numId);
        if (conf == null) {
            return null;
        }

        return conf.getRaw();
    }

    @Override
    public void onConfigurationLoad(SolomonConfWithContext conf) {
        this.context = conf;
    }
}
