package ru.yandex.solomon.gateway.cloud.billing.stockpile;

import java.util.List;

import javax.annotation.WillCloseWhenClosed;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileCrossDcUsageProvider implements StockpileUsageProvider {
    @WillCloseWhenClosed
    private final List<StockpileUsageProvider> sources;
    private int capacity;

    public StockpileCrossDcUsageProvider(@WillCloseWhenClosed List<StockpileUsageProvider> sources) {
        if (sources.size() < 2) {
            throw new IllegalStateException("not enough data for dc aggregation: " + sources.size());
        }
        this.sources = sources;
    }

    @Override
    public StockpileUsage getUsage() {
        StockpileUsage total = new StockpileUsage(capacity);
        for (var source : sources) {
            total.max(source.getUsage());
        }
        capacity = total.usageByKey.size();
        return total;
    }

    @Override
    public void close() {
        for (var source : sources) {
            source.close();
        }
    }

    @Override
    public String toString() {
        return "StockpileCrossDcUsageProvider{" + sources + '}';
    }
}
