package ru.yandex.solomon.gateway.cloud.billing.stockpile;

import java.util.List;

import javax.annotation.WillCloseWhenClosed;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileDcUsageProvider implements StockpileUsageProvider {
    private final String name;
    @WillCloseWhenClosed
    private final List<StockpileUsageProvider> hosts;
    private int capacity;

    public StockpileDcUsageProvider(String name, @WillCloseWhenClosed List<StockpileUsageProvider> hosts) {
        if (hosts.size() < 2) {
            throw new IllegalStateException("not enough hosts for cluster aggregation: " + hosts.size());
        }
        this.name = name;
        this.hosts = hosts;
    }

    @Override
    public StockpileUsage getUsage() {
        StockpileUsage total = new StockpileUsage(capacity);
        for (var host : hosts) {
            total.combine(host.getUsage());
        }
        capacity = total.usageByKey.size();
        return total;
    }

    @Override
    public void close() {
        for (var host : hosts) {
            host.close();
        }
    }

    @Override
    public String toString() {
        return "StockpileDcUsageProvider{" + name + '}';
    }
}
