package ru.yandex.solomon.gateway.cloud.search;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

import ru.yandex.solomon.alert.client.AlertApi;
import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.alert.protobuf.TListAlertRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertFetcher extends AbstractAlertingFetcher<TAlert> {
    private final AlertApi api;

    public AlertFetcher(ProjectsSupplier projectsSupplier, AlertApi api, Executor executor) {
        super(projectsSupplier, executor);
        this.api = api;
    }

    @Override
    protected CompletableFuture<ListResult<TAlert>> fetchNext(String projectId, String nextToken) {
        var req = TListAlertRequest.newBuilder()
                .setProjectId(projectId)
                .setPageToken(nextToken)
                .setPageSize(PAGE_SIZE)
                .setFullResultModel(true)
                .build();

        return api.listAlerts(req)
                .thenApply(response -> {
                    ensureStatusValid(response.getRequestStatus(), response::getStatusMessage);
                    return new ListResult<>(response.getNextPageToken(), response.getAlertList().getAlertsList());
                });
    }

    @Override
    protected String folderId(TAlert entry) {
        return entry.getFolderId();
    }

    @Override
    protected SearchEvent convert(TAlert entry) {
        return SearchEvent.alert(entry);
    }

    private void ensureStatusValid(ERequestStatusCode statusCode, Supplier<String> messageFn) {
        if (statusCode != ERequestStatusCode.OK) {
            throw new RuntimeException(statusCode + ":" + messageFn.get());
        }
    }
}
