package ru.yandex.solomon.gateway.cloud.search;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

import ru.yandex.solomon.alert.client.NotificationApi;
import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.TListNotificationsRequest;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;

/**
 * @author Vladimir Gordiychuk
 */
public class ChannelFetcher extends AbstractAlertingFetcher<TNotification> {
    private final NotificationApi api;

    public ChannelFetcher(ProjectsSupplier projectsSupplier, NotificationApi api, Executor executor) {
        super(projectsSupplier, executor);
        this.api = api;
    }

    @Override
    protected CompletableFuture<ListResult<TNotification>> fetchNext(String projectId, String nextToken) {
        var req = TListNotificationsRequest.newBuilder()
                .setProjectId(projectId)
                .setPageToken(nextToken)
                .setPageSize(PAGE_SIZE)
                .build();

        return api.listNotification(req)
                .thenApply(response -> {
                    ensureStatusValid(response.getRequestStatus(), response::getStatusMessage);
                    return new ListResult<>(response.getNextPageToken(), response.getNotificationList());
                });
    }

    @Override
    protected String folderId(TNotification entry) {
        return entry.getFolderId();
    }

    @Override
    protected SearchEvent convert(TNotification entry) {
        return SearchEvent.channel(entry);
    }

    private void ensureStatusValid(ERequestStatusCode statusCode, Supplier<String> messageFn) {
        if (statusCode != ERequestStatusCode.OK) {
            throw new RuntimeException(statusCode + ":" + messageFn.get());
        }
    }
}
