package ru.yandex.solomon.gateway.cloud.search;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;
import ru.yandex.solomon.conf.db3.ydb.Entity;

/**
 * @author Vladimir Gordiychuk
 */
public class SearchEvent extends DefaultObject {
    public String cloudId;
    public String folderId;
    public String resourceId;
    public String resourceType;
    public String name;
    public String description;
    public long updatedAt;
    public long deletedAt;
    public long reindexAt;

    public SearchEvent() {
    }

    public SearchEvent(SearchEvent copy) {
        this.cloudId = copy.cloudId;
        this.folderId = copy.folderId;
        this.resourceId = copy.resourceId;
        this.resourceType = copy.resourceType;
        this.name = copy.name;
        this.description = copy.description;
        this.updatedAt = copy.updatedAt;
        this.deletedAt = copy.deletedAt;
        this.reindexAt = copy.reindexAt;
    }

    public SearchEvent setCloudId(String cloudId) {
        this.cloudId = cloudId;
        return this;
    }

    public SearchEvent setFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public SearchEvent setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public SearchEvent setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public SearchEvent setName(String name) {
        this.name = name;
        return this;
    }

    public SearchEvent setDescription(String description) {
        this.description = description;
        return this;
    }

    public SearchEvent setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public SearchEvent deletedAt(long deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    public static SearchEvent dashboard(String cloudId, Entity dashboard) {
        return new SearchEvent()
                .setCloudId(cloudId)
                .setFolderId(dashboard.getParentId())
                .setResourceId(dashboard.getId())
                .setResourceType("dashboard")
                .setName(dashboard.getName())
                .setDescription(dashboard.getDescription())
                .setUpdatedAt(dashboard.getUpdatedAt());
    }

    public static SearchEvent alert(TAlert alert) {
        return new SearchEvent()
                .setCloudId(alert.getProjectId())
                .setFolderId(alert.getFolderId())
                .setResourceId(alert.getId())
                .setResourceType("alert")
                .setName(alert.getName())
                .setDescription(alert.getDescription())
                .setUpdatedAt(alert.getUpdatedAt());
    }

    public static SearchEvent channel(TNotification channel) {
        return new SearchEvent()
                .setCloudId(channel.getProjectId())
                .setFolderId(channel.getFolderId())
                .setResourceId(channel.getId())
                .setResourceType("channel")
                .setName(channel.getName())
                .setDescription(channel.getDescription())
                .setUpdatedAt(channel.getUpdatedAt());
    }

}
