package ru.yandex.solomon.gateway.cloud.search;

import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.logbroker.agent.client.Session;

/**
 * @author Vladimir Gordiychuk
 */
public class SearchEventSinkImpl implements SearchEventSink, AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SearchEventSinkImpl.class);

    @WillCloseWhenClosed
    private final Session session;
    @Nullable
    @SuppressWarnings("unused")
    private volatile String latest;

    public SearchEventSinkImpl(@WillCloseWhenClosed Session session) {
        this.session = session;
    }

    @Override
    public void accept(SearchEvent event) {
        String json = SearchEventConverter.toJson(event);
        logger.debug("send: {}", json);
        latest = json;
        session.send(json);
    }

    @Override
    public void close() throws Exception {
        session.close();
    }
}
