package ru.yandex.solomon.gateway.cloud.unified_agent;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.config.gateway.UnifiedAgentInstallerConfig;

/**
 * @author Alexey Trushkin
 */
@RestController
@RequestMapping(path = "/monitoring/v2/unifiedAgent/config")
@ParametersAreNonnullByDefault
public class CloudConfigController {

    private final UnifiedAgentInstaller installer;

    public CloudConfigController(UnifiedAgentInstallerConfig config) {
        this.installer = new UnifiedAgentInstaller(config);
    }

    @RequestMapping(path = "/userData", method = RequestMethod.GET, produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    public CompletableFuture<byte[]> userData() {
        return CompletableFuture.completedFuture(installer.userDataBytes());
    }

    @RequestMapping(path = "/install.sh", method = RequestMethod.GET, produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    public CompletableFuture<byte[]> install() {
        return CompletableFuture.completedFuture(installer.installShBytes());
    }

}
