#!/bin/bash
folder_id=$(curl -H 'Metadata-Flavor:Google' -s http://169.254.169.254/computeMetadata/v1/yandex/folder-id)

mkdir -p /etc/yc/unified_agent
cat >/etc/yc/unified_agent/config.yml <<EOL
${ua_config}
EOL

mkdir -p /lib/systemd/system
cat >/lib/systemd/system/unified_agent.service <<EOL
${ua_systemd_service}
EOL

ua_version=$(curl -s ${s3_bucket_address}/latest-version) bash -c 'curl -s -O ${s3_bucket_address}/releases/$ua_version/unified_agent && chmod +x ./unified_agent'
sudo mv unified_agent /bin/unified_agent
sudo systemctl enable unified_agent.service
sudo systemctl start unified_agent.service
sudo systemctl status unified_agent.service
