package ru.yandex.solomon.gateway.cloud.api;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.common.RequestProducer;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class RequestProducerResolverTest {
    private RequestProducerResolverImpl resolver;

    @Before
    public void setUp() {
        resolver = new RequestProducerResolverImpl("my-super-secret-key");
    }

    @Test
    public void absentHeader() {
        assertEquals(RequestProducer.USER, resolver.resolve(null));
        assertEquals(RequestProducer.USER, resolver.resolve(""));
    }

    @Test
    public void invalidHeader() {
        assertEquals(RequestProducer.USER, resolver.resolve("hacked"));
        assertEquals(RequestProducer.USER, resolver.resolve("it's not valid header"));
        assertEquals(RequestProducer.USER, resolver.resolve("one:two:three:four"));
    }

    @Test
    public void invalidSignature() {
        assertEquals(RequestProducer.USER, resolver.resolve("CUXZ0vOZweWm9K4YHfb/3YZcyZZ=:ui:gordiychuk:1564144011"));
        assertEquals(RequestProducer.USER, resolver.resolve("hacked=:ui:gordiychuk:1564144011"));
        assertEquals(RequestProducer.USER, resolver.resolve("CUXZ0vOZweWm9K4YHfb/3YZcyQQ=:ui:gordiychuk:"));
    }

    @Test
    public void staffSigned() {
        var sign = resolver.sign("gordiychuk", "1564144011");
        assertEquals(RequestProducer.STAFF, resolver.resolve(sign + ":ui:gordiychuk:1564144011"));
    }

    @Test
    public void userSigned() {
        var sign = resolver.sign("", "1564144011");
        assertEquals(RequestProducer.SYSTEM, resolver.resolve(sign + ":ui::1564144011"));
    }
}
