package ru.yandex.solomon.gateway.cloud.billing;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;

import javax.annotation.Nullable;

import ru.yandex.solomon.gateway.cloud.billing.stockpile.StockpileUsage;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
public class BillingEndpointStub implements BillingEndpoint {

    private volatile CompletableFuture<Void> future = new CompletableFuture<>();
    @Nullable
    private volatile Request pushed;
    public volatile CountDownLatch sync = new CountDownLatch(1);

    @Override
    public CompletableFuture<Void> push(StockpileUsage usage, Interval interval, long leaderSeqNo) {
        CompletableFuture<Void> future = new CompletableFuture<>();
        if (this.pushed != null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Prev not pulled yet"));
        }
        try {
            this.pushed = new Request(usage, interval, leaderSeqNo);
            this.future = future;
            return future;
        } finally {
            var copy = sync;
            sync = new CountDownLatch(1);
            copy.countDown();
        }
    }

    public Request getPushed() {
        var copy = pushed;
        pushed = null;
        future.complete(null);
        return copy;
    }

    public static class Request {
        public final StockpileUsage usage;
        public final Interval interval;
        public final long leaderSeqNo;

        public Request(StockpileUsage usage, Interval interval, long leaderSeqNo) {
            this.usage = usage;
            this.interval = interval;
            this.leaderSeqNo = leaderSeqNo;
        }
    }
}
