package ru.yandex.solomon.gateway.cloud.billing;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;

import com.google.common.net.HostAndPort;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class BillingResourceFetcherStub implements BillingResourceFetcher {
    private final MetricRegistry registry;
    public volatile CountDownLatch sync = new CountDownLatch(1);

    public BillingResourceFetcherStub(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public CompletableFuture<Void> fetch(HostAndPort address, MetricConsumer consumer) {
        return CompletableFuture.runAsync(() -> registry.supply(0, consumer))
            .whenComplete((ignore, e) -> {
                var copy = sync;
                sync = new CountDownLatch(1);
                copy.countDown();
            });
    }
}
