package ru.yandex.solomon.gateway.cloud.billing;

import java.util.concurrent.ThreadLocalRandom;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.core.db.model.Shard;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class BillingShardFilterTest {

    private ShardByNumIdResolverStub resolver;
    private BillingShardFilter filter;

    @Before
    public void setUp() {
        resolver = new ShardByNumIdResolverStub();
        filter = new BillingShardFilter(resolver);
    }

    @Test
    public void noBillUnknownShards() {
        assertFalse(filter.test(42));
        assertFalse(filter.test(0));
        assertFalse(filter.test(ThreadLocalRandom.current().nextInt()));
    }

    @Test
    public void noBillSystemShards() {
        Shard sys = Shard.newBuilder()
            .setId("my_super_shard_custom")
            .setNumId(42)
            .setClusterId("my_cluster_custom")
            .setClusterName("my_cluster_custom")
            .setProjectId("solomon")
            .setServiceName("sys_custom")
            .setServiceId("sys_custom")
            .build();

        resolver.addShard(sys);
        assertFalse(filter.test(sys.getNumId()));
    }

    @Test
    public void billCustomShards() {
        Shard custom = Shard.newBuilder()
            .setId("b1g86hg3icuf07_b1gfn2nk2sdf35v70o17_custom")
            .setNumId(42)
            .setProjectId("b1g86hg3icuf07")
            .setClusterName("b1gfn2nk2sdf35v70o17")
            .setClusterId("b1g86hg3icuf07_b1gfn2nk2sdf35v70o17")
            .setServiceName("custom")
            .setServiceId("b1g86hg3icuf07_custom")
            .build();

        resolver.addShard(custom);
        assertTrue(filter.test(custom.getNumId()));
    }
}
