package ru.yandex.solomon.gateway.cloud.billing;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.logbroker.agent.client.LogMessage;
import ru.yandex.logbroker.agent.client.Session;
import ru.yandex.logbroker.agent.client.SessionMetrics;
import ru.yandex.logbroker.agent.internal.SessionState;

public class SessionStub implements Session {
    private final Logger logger = LoggerFactory.getLogger(SessionStub.class);
    public ArrayBlockingQueue<String> receivedMessages = new ArrayBlockingQueue<>(1000);

    @Override
    public void send(String message) {
        receivedMessages.add(message);
    }

    @Override
    public void send(String message, long ts) {
        send(message);
    }

    @Override
    public void send(LogMessage logMessage) {
        send(logMessage.toString());
    }

    @Override
    public void send(List<LogMessage> messages) {
        messages.forEach(this::send);
    }

    @Override
    public void send(String... messages) {
        for (String message: messages) {
            send(message);
        }
    }

    @Override
    public SessionMetrics metrics() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SessionState getState() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void close() throws ExecutionException, InterruptedException {
        logger.info("Session closed");
    }
}
