package ru.yandex.solomon.gateway.cloud.billing;

import javax.annotation.Nullable;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

import ru.yandex.solomon.core.db.model.Shard;

/**
 * @author Vladimir Gordiychuk
 */
public class ShardByNumIdResolverStub implements ShardByNumIdResolver {
    private Int2ObjectMap<Shard> shards = new Int2ObjectOpenHashMap<>();

    public void addShard(Shard shard) {
        shards.put(shard.getNumId(), shard);
    }

    @Nullable
    @Override
    public Shard resolve(int numId) {
        return shards.get(numId);
    }
}
