package ru.yandex.solomon.gateway.cloud.billing;

import java.io.StringWriter;
import java.util.concurrent.ForkJoinPool;

import com.google.common.net.HostAndPort;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.monlib.metrics.encode.text.MetricTextEncoder;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.gateway.cloud.billing.stockpile.StockpileBillingResourceFetcher;

import static org.hamcrest.Matchers.containsString;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
@YaIgnore
public class StockpileBillingResourceFetcherTest {

    private BillingResourceFetcher fetcher;

    @Before
    public void setUp() {
        fetcher = new StockpileBillingResourceFetcher(ForkJoinPool.commonPool(), new MetricRegistry());
    }

    @Test
    public void fetchUsage() {
        StringWriter writer = new StringWriter();
        MetricTextEncoder encoder = new MetricTextEncoder(writer, true);

        fetcher.fetch(HostAndPort.fromString("solomon-pre-storage-man-010.search.yandex.net:4500"), encoder).join();

        String result = writer.toString();
        System.out.println(result);
        assertThat(result, containsString("stockpile.write.records.rate"));
    }
}
