package ru.yandex.solomon.gateway.cloud.search;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourceFetcherStub implements ResourceFetcher {
    private final ConcurrentMap<Key, SearchEvent> resources = new ConcurrentHashMap<>();
    public volatile Throwable error;

    public void add(List<SearchEvent> events) {
        for (var event : events) {
            add(event);
        }
    }

    public void add(SearchEvent event) {
        var key = new Key(event.cloudId, event.resourceId);
        resources.put(key, event);
    }

    @Override
    public CompletableFuture<Void> fetch(Consumer<SearchEvent> consumer) {
        return CompletableFuture.runAsync(() -> {
            if (error != null) {
                throw new RuntimeException(error);
            }

            resources.values().forEach(event -> consumer.accept(new SearchEvent(event)));
        });
    }

    private static record Key(String cloudId, String resourceId) {}
}
