package ru.yandex.solomon.gateway.cloud.search;

import org.junit.Test;

import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;
import ru.yandex.solomon.conf.db3.ydb.Entity;
import ru.yandex.solomon.core.container.ContainerType;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class SearchEventTest {

    @Test
    public void dashboard() {
        var now = System.currentTimeMillis();
        var dashboard = Entity.newBuilder()
                .setId("myId")
                .setParentId("myFolderId")
                .setContainerType(ContainerType.FOLDER)
                .setName("myName")
                .setUpdatedBy("user")
                .setUpdatedAt(now)
                .build();

        var event = SearchEvent.dashboard("myProjectId", dashboard);
        assertEquals("myProjectId", event.cloudId);
        assertEquals("myFolderId", event.folderId);
        assertEquals("myName", event.name);
        assertEquals("myId", event.resourceId);
        assertEquals("dashboard", event.resourceType);
        assertEquals(now, event.updatedAt);
        assertEquals(0, event.deletedAt);
        assertEquals(0, event.reindexAt);
    }

    @Test
    public void alert() {
        var now = System.currentTimeMillis();
        var alert = TAlert.newBuilder()
                .setId("myId")
                .setProjectId("myProjectId")
                .setFolderId("myFolderId")
                .setName("myName")
                .setDescription("test")
                .setUpdatedBy("user")
                .setUpdatedAt(now)
                .setCreatedAt(now)
                .build();

        var event = SearchEvent.alert(alert);
        assertEquals("myProjectId", event.cloudId);
        assertEquals("myFolderId", event.folderId);
        assertEquals("myName", event.name);
        assertEquals("test", event.description);
        assertEquals("myId", event.resourceId);
        assertEquals("alert", event.resourceType);
        assertEquals(now, event.updatedAt);
        assertEquals(0, event.deletedAt);
        assertEquals(0, event.reindexAt);
    }

    @Test
    public void channel() {
        var now = System.currentTimeMillis();
        var channel = TNotification.newBuilder()
                .setId("myId")
                .setProjectId("myProjectId")
                .setFolderId("myFolderId")
                .setName("myName")
                .setDescription("test")
                .setUpdatedBy("user")
                .setUpdatedAt(now)
                .setCreatedAt(now)
                .build();

        var event = SearchEvent.channel(channel);
        assertEquals("myProjectId", event.cloudId);
        assertEquals("myFolderId", event.folderId);
        assertEquals("myName", event.name);
        assertEquals("test", event.description);
        assertEquals("myId", event.resourceId);
        assertEquals("channel", event.resourceType);
        assertEquals(now, event.updatedAt);
        assertEquals(0, event.deletedAt);
        assertEquals(0, event.reindexAt);
    }
}
