package ru.yandex.solomon.gateway.cloud.unified_agent;

import org.hamcrest.Matchers;
import org.junit.Test;

import ru.yandex.solomon.config.gateway.UnifiedAgentInstallerConfig;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class UnifiedAgentInstallerTest {

    @Test
    public void load() {
        assertNotNull(UnifiedAgentInstaller.load("install/config.yml"));
    }

    @Test
    public void loadUserDataYml() {
        var config = UnifiedAgentInstallerConfig.newBuilder()
                .setApiAddress("monitoring-test-1.mon.net")
                .build();
        String result = UnifiedAgentInstaller.loadUserDataYml(config);
        assertParamsReplaces(result);
        assertThat(result, Matchers.containsString("monitoring-test-1.mon.net/monitoring/v2/unifiedAgent/config/install.sh"));
    }

    @Test
    public void loadConfigYml() {
        var config = UnifiedAgentInstallerConfig.newBuilder()
                .setApiAddress("monitoring-test.mon.net")
                .build();

        String result = UnifiedAgentInstaller.loadConfigYml(config);
        assertParamsReplaces(result);
        assertThat(result, Matchers.containsString("monitoring-test.mon.net/monitoring/v2/data/write"));
        assertThat(result, Matchers.containsString("$folder_id"));
    }

    @Test
    public void loadSystemdUnit() {
        var config = UnifiedAgentInstallerConfig.newBuilder()
                .setApiAddress("monitoring-test.mon.net")
                .build();

        String result = UnifiedAgentInstaller.loadSystemdUnit(config);
        assertParamsReplaces(result);
        assertThat(result, Matchers.containsString("/bin/unified_agent"));
    }

    @Test
    public void loadInstallSh() {
        var config = UnifiedAgentInstallerConfig.newBuilder()
                .setApiAddress("https://monitoring-test.mon.net")
                .setS3BucketAddress("https://s3.bucket.mon.net")
                .build();

        String result = UnifiedAgentInstaller.loadInstallSh(config);
        assertParamsReplaces(result);
        assertThat(result, Matchers.containsString("https://monitoring-test.mon.net"));
        assertThat(result, Matchers.containsString("https://s3.bucket.mon.net/releases/$ua_version/unified_agent"));
    }

    private static void assertParamsReplaces(String result) {
        assertThat(result, Matchers.not(Matchers.containsString("api_address")));
        assertThat(result, Matchers.not(Matchers.containsString("s3_bucket_address")));
        assertThat(result, Matchers.not(Matchers.containsString("ua_config")));
        assertThat(result, Matchers.not(Matchers.containsString("ua_systemd_service")));
    }

}
