#include "http.h"

#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>
#include <solomon/libs/cpp/http/server/handlers/metrics.h>
#include <solomon/libs/cpp/http/server/handlers/version.h>
#include <solomon/libs/cpp/http/server/config/http_server_config.pb.h>
#include <solomon/libs/cpp/selfmon/service/service.h>

using yandex::solomon::config::http::HttpServerConfig;

namespace NSolomon::NIngestor {

std::unique_ptr<NSolomon::NHttp::THttpServer> StartHttpServer(
    TActorRuntime& runtime,
    NMonitoring::IMetricSupplier& shardMetricsSupplier,
    NMonitoring::IMetricSupplier& hostMetricsSupplier,
    const std::shared_ptr<NMonitoring::TMetricRegistry>& counters,
    const HttpServerConfig& config)
{
    Cerr << "Mon server listening on http://" << config.bind() << ':' << config.port() << Endl;

    // TODO: remove non standard http server config
    ::yandex::monitoring::HttpServerConfig anotherConfig;
    anotherConfig.set_host(config.bind());
    auto* portConfig = anotherConfig.add_ports();
    portConfig->set_port(config.port());
    portConfig->set_secure(false);
    anotherConfig.set_executor_pool(config.threadpoolname());

    auto httpServer = std::make_unique<NSolomon::NHttp::THttpServer>(runtime, counters, anotherConfig);
    httpServer->Handle("/metrics/shards", NSolomon::NHttp::TMetricsHandler{shardMetricsSupplier});
    httpServer->Handle("/metrics/host", NSolomon::NHttp::TMetricsHandler{hostMetricsSupplier});
    httpServer->Handle("/metrics", NSolomon::NHttp::CreateMetricsHandler(counters));
    httpServer->Handle("/version", NSolomon::NHttp::TVersionHandler{});
    NSelfMon::InitService(counters, runtime.ActorSystem(), httpServer->Proxy(), httpServer->ExecutorId());
    return httpServer;
}

} // namespace NSolomon::NIngestor
