#include <solomon/services/ingestor/api/ingestor_grpc_service.grpc.pb.h>
#include <solomon/services/ingestor/lib/shard_manager/shard_manager.h>

#include <solomon/libs/cpp/grpc/server/handler.h>
#include <solomon/libs/cpp/proto_convert/format.h>
#include <solomon/libs/cpp/proto_convert/labels.h>

using namespace NActors;

using yandex::monitoring::ingestor::TGetAssignedShardsRequest;
using yandex::monitoring::ingestor::TGetAssignedShardsResponse;

namespace NSolomon::NIngestor::NApi {
namespace {

class TGetAssignedShardsHandler: public NGrpc::TBaseHandler<TGetAssignedShardsHandler> {
public:
    explicit TGetAssignedShardsHandler(TActorId shardManager) noexcept
        : ShardManager_(shardManager)
    {
    }

public:
    STATEFN(HandleEvent) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TShardManagerEvents::TEvGetAssignedShardsResult, OnGetAssignedShardsResult);
        }
    }

    EMode HandleRequest(NGrpc::TRequestState* req) {
        Send(ShardManager_, new TShardManagerEvents::TEvGetAssignedShards, 0, req->ToCookie());
        return EMode::Async;
    }

    void OnGetAssignedShardsResult(const TShardManagerEvents::TEvGetAssignedShardsResult::TPtr& ev) {
        auto req = NGrpc::TRequestState::FromCookie(ev->Cookie);
        if (req->IsReplied()) {
            // request was already expired
            return;
        }

        try {
            auto* resp = google::protobuf::Arena::CreateMessage<TGetAssignedShardsResponse>(req->Arena());
            auto& numIds = ev->Get()->NumIds;

            if (int size = static_cast<int>(numIds.size())) {
                auto* numIdsProto = resp->mutable_numids();
                numIdsProto->Reserve(size);
                std::copy(numIds.begin(), numIds.end(), numIdsProto->AddNAlreadyReserved(size));
            }

            req->SendReply(resp);
        } catch (...) {
            req->SendError(grpc::INTERNAL, "internal error: " + CurrentExceptionMessage());
        }
    }

private:
    TActorId ShardManager_;
};

} // namespace

IActor* CreateGetAssignedShardsHandler(TActorId shardManager) {
    return new TGetAssignedShardsHandler{shardManager};
}

} // namespace NSolomon::NIngestor::NApi
