#include "service.h"

#include <solomon/services/ingestor/api/ingestor_grpc_service.grpc.pb.h>

#include <solomon/libs/cpp/grpc/server/service.h>

using namespace NActors;
using yandex::monitoring::ingestor::IngestorService;

namespace NSolomon::NIngestor::NApi {

IActor* CreateProcessPulledDataHandler(TActorId shardManager);
IActor* CreateProcessPushedDataHandler(TActorId shardManager);
IActor* CreateCreateShardHandler(TActorId shardManager);
IActor* CreateGetAssignedShardsHandler(TActorId shardManager);

namespace {

/// Main GRPC service that provides all public API.
class TIngestorService: public NSolomon::NGrpc::TService<IngestorService> {
public:
    TIngestorService(
            TActorSystem& actorSystem,
            NMonitoring::TMetricRegistry& registry,
            ui32 executorPool,
            TActorId shardManager)
        : TService{actorSystem, registry, executorPool}
        , ShardManager_{shardManager}
    {
    }

public:
    void InitHandlers(grpc::ServerCompletionQueue* cq) override {
        using AsyncService = IngestorService::AsyncService;

        RegisterSingleHandler(cq, &AsyncService::RequestProcessPulledData, "ProcessPulledData", CreateProcessPulledDataHandler(ShardManager_));
        RegisterSingleHandler(cq, &AsyncService::RequestProcessPushedData, "ProcessPushedData", CreateProcessPushedDataHandler(ShardManager_));
        RegisterSingleHandler(cq, &AsyncService::RequestCreateShard, "CreateShard", CreateCreateShardHandler(ShardManager_));
        RegisterSingleHandler(cq, &AsyncService::RequestGetAssignedShards, "GetAssignedShards", CreateGetAssignedShardsHandler(ShardManager_));
    }

private:
    TActorId ShardManager_;
};

} // namespace

TIntrusivePtr<::NGrpc::IGRpcService> CreateIngestorService(
        TActorSystem& actorSystem,
        NMonitoring::TMetricRegistry& registry,
        ui32 executorPool,
        TActorId shardManager)
{
    return MakeIntrusive<TIngestorService>(actorSystem, registry, executorPool, shardManager);
}

} // namespace NSolomon::NIngestor::NApi
