#include <solomon/services/ingestor/lib/config/config.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/system/tempfile.h>

using yandex::monitoring::ingestor::IngestorConfig;
using namespace NSolomon::NIngestor;

namespace {

void ValidateResource(TStringBuf name) {
    TString configText = NResource::Find(name);
    ASSERT_FALSE(configText.Empty()) << "cannot find resource " << name;

    TTempFileHandle tmp;
    tmp.Write(configText.data(), configText.size());
    tmp.FlushData();

    IngestorConfig config;
    ASSERT_NO_THROW({ config = ParseTextProto(tmp.Name()); }) << "cannot parse config " << name;
    ASSERT_NO_THROW({ Validate(config); }) << "non valid config " << name;
}

} // namespace

TEST(TConfigTest, Dev) {
    ValidateResource("dev/ingestor.conf");
}

TEST(TConfigTest, Prestable) {
    ValidateResource("prestable/ingestor.conf");
}

TEST(TConfigTest, Production) {
    ValidateResource("production/ingestor.conf");
}

TEST(TConfigTest, Testing) {
    ValidateResource("testing/ingestor.conf");
}
