#pragma once

#include <solomon/services/ingestor/config/ingestor_config.pb.h>
#include <solomon/services/ingestor/api/ingestor_grpc_service.pb.h>

#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/actors/core/actor.h>

namespace NSolomon::NIngestor {

class IRequestTracer: public TAtomicRefCount<IRequestTracer> {
public:
    virtual ~IRequestTracer() = default;

    virtual void Trace(const yandex::monitoring::ingestor::TPulledDataRequest& req) = 0;
    virtual void Trace(const yandex::monitoring::ingestor::TPushedDataRequest& req) = 0;
};
using IRequestTracerPtr = TIntrusivePtr<IRequestTracer>;

IRequestTracerPtr CreateRequestTracer(
    const yandex::monitoring::ingestor::RequestTracerConfig& conf,
    NSolomon::TActorRuntime& actorRuntime,
    NMonitoring::TMetricRegistry& registry);

IRequestTracerPtr CreateRequestTracer(
    const yandex::monitoring::ingestor::RequestTracerConfig& conf,
    NActors::TActorSystem& actorSystem,
    NActors::TActorId actorId,
    NMonitoring::TMetricRegistry& registry);
} // namespace NSolomon::NIngestor
