#pragma once

#include <solomon/services/ingestor/api/ingestor_grpc_service.pb.h>
#include <solomon/services/ingestor/lib/events/events.h>

#include <solomon/libs/cpp/actors/events/events.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NIngestor {
struct TRequestTracerEvent: private TEventSlot<EEventSpace::Ingestor, IS_TRACE_ACTOR> {
    enum {
        TracePull = SpaceBegin,
        TracePush,
        TraceResp,
        End,
    };

    static_assert(End < SpaceEnd, "too many event types");

    struct TTracePull: NActors::TEventLocal<TTracePull, TRequestTracerEvent::TracePull> {
        explicit TTracePull(yandex::monitoring::ingestor::TPulledDataRequest request)
            : Request(std::move(request))
        {
        }

        yandex::monitoring::ingestor::TPulledDataRequest Request;
        bool SendReply{false};
    };

    struct TTracePush: NActors::TEventLocal<TTracePush, TRequestTracerEvent::TracePush> {
        explicit TTracePush(yandex::monitoring::ingestor::TPushedDataRequest request)
            : Request(std::move(request))
        {
        }

        yandex::monitoring::ingestor::TPushedDataRequest Request;
        bool SendReply{false};
    };

    struct TTraceResp: NActors::TEventLocal<TTraceResp, TRequestTracerEvent::TraceResp> {};
};

std::unique_ptr<NActors::IActor> CreateRequestTracerActor(const TString& path);
}
