#include "labels.h"

#include <solomon/libs/cpp/labels/known_keys.h>
#include <solomon/libs/cpp/yasm/constants/labels.h>

#include <util/string/builder.h>

namespace NSolomon::NIngestor {

TLabelPool::TLabelPool()
    : HostIntTag(Intern(NLabels::LABEL_HOST))
    , GroupIntTag(Intern(NLabels::LABEL_GROUP))
    , AggrIntTag(Intern(NYasm::AGGREGATED_MARKER))
    , ContainerIntTag(Intern(CONTAINER_TAG))
    , SignalIntTag(Intern(NYasm::LABEL_SIGNAL))
{
    Update();
}

TLabelPool* TLabels::LabelPool() const {
    return LabelPool_;
}

TStringBuf TLabels::Name(size_t index) const {
    return LabelPool_->Find(this->at(index).first);
}

TStringBuf TLabels::Value(size_t index) const {
    return LabelPool_->Find(this->at(index).second);
}

TString TLabels::AsString() const {
    TStringBuilder sb;
    sb << "{";
    for (size_t i = 0; i < size(); ++i) {
        sb << Name(i) << "=" << Value(i);
        if (i + 1 != size()) {
            sb << ",";
        }
    }
    sb << "}";

    return sb;
}

bool TLabels::operator==(const TLabels &other) const {
    return LabelPool_ == other.LabelPool_ && static_cast<const TBase&>(*this) ==  static_cast<const TBase&>(other);
}

TLabels::TLabels(TLabelPool* pool)
    : LabelPool_(pool)
{
}

} // namespace NSolomon::NIngestor
