#pragma once

#include "validation_modes.h"
#include "prev_values_supplier.h"
#include "aggregation_state.h"
#include "yasm_aggregator.h"
#include "processing_error_listner.h"

#include <solomon/services/ingestor/lib/shard_id.h>

#include <solomon/libs/cpp/log_writer/log_writer.h>
#include <solomon/libs/cpp/intern/str_pool.h>
#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric_consumer.h>

#include <util/datetime/base.h>

namespace NSolomon::NIngestor {

class TQuotaError: public yexception {
};

class TParseError: public yexception {
};

struct TCoremonShardQuota {
    ui64 MaxMetricsPerUrl{0};
    ui64 MaxFileMetrics{0};
    ui64 MaxMemMetrics{0};
};

struct TMetricProcessorOptions {
    NMonitoring::TLabels CommonLabels;
    NMonitoring::TLabels CommonOptLabels; // sorted
    TInstant ResponseTs;
    TCoremonShardQuota Quota;
    bool IsShardMemOnly{false};
    IProcessingErrorListener* Errors;
    TValidationMode ValidationMode;
    TYasmAggrState* YasmAggrState;
    TInstant IntervalStart;
    TDuration IntervalLength;
    TLabelPool* LabelPool;
};

struct TProcessingStatus {
    yandex::solomon::common::UrlStatusType StatusType{}; // UNNKNOWN
    TString Message;
    ui32 MetricsWritten{0};
};

class IMetricProcessor: public NMonitoring::IMetricConsumer {
public:
    virtual TProcessingStatus Status() = 0;
};

using IMetricProcessorPtr = THolder<IMetricProcessor>;

// Will call OnStreamBegin()/OnStreamEnd() of writer.
// Returned processor can be used only to process a single document.
IMetricProcessorPtr CreateMetricProcessor(
        TMetricProcessorOptions opts,
        ILogWriter* writer);

// Will not call OnStreamBegin()/OnStreamEnd() of writer, so caller have to call it manually.
// But then this processor can be reused to process several documents.
IMetricProcessorPtr CreateBatchMetricProcessor(
        TMetricProcessorOptions opts,
        ILogWriter* writer);

} // namespace NSolomon::NIngestor
