#pragma once

#include <util/generic/string.h>

namespace NSolomon::NIngestor {

enum class EInvalidMetricReason {
    EMPTY_LABELS = 0,
    TOO_MANY_LABELS,
    INVALID_VALUE,
    INVALID_LABEL,
    INVALID_LABEL_NAME,
    INVALID_LABEL_VALUE,
    UNKNOWN_FIELD,
    UNKNOWN_FORMAT,
    INVALID_METRIC_NAME,
    INVALID_VALUE_TYPE,
    INVALID_AGGR_SUFFIX,
    UNKNOWN_ERROR,

    // this is fake item and it must be the last field of enumeration
    ERRORS_NUMBER,
};

inline TString InvalidMetricReasonToStr(EInvalidMetricReason reason) {
    switch (reason) {
        case EInvalidMetricReason::EMPTY_LABELS:
            return TString("EMPTY_LABELS");
        case EInvalidMetricReason::TOO_MANY_LABELS:
            return TString("TOO_MANY_LABELS");
        case EInvalidMetricReason::INVALID_VALUE:
            return TString("INVALID_VALUE");
        case EInvalidMetricReason::INVALID_LABEL:
            return TString("INVALID_LABEL");
        case EInvalidMetricReason::INVALID_LABEL_NAME:
            return TString("INVALID_LABEL_NAME");
        case EInvalidMetricReason::INVALID_LABEL_VALUE:
            return TString("INVALID_LABEL_VALUE");
        case EInvalidMetricReason::UNKNOWN_FIELD:
            return TString("UNKNOWN_FIELD");
        case EInvalidMetricReason::UNKNOWN_FORMAT:
            return TString("UNKNOWN_FORMAT");
        case EInvalidMetricReason::INVALID_METRIC_NAME:
            return TString("INVALID_METRIC_NAME");
        case EInvalidMetricReason::INVALID_VALUE_TYPE:
            return TString("INVALID_VALUE_TYPE");
        case EInvalidMetricReason::INVALID_AGGR_SUFFIX:
            return TString("INVALID_AGGR_SUFFIX");
        case EInvalidMetricReason::UNKNOWN_ERROR:
            return TString("UNKNOWN_ERROR");
        case EInvalidMetricReason::ERRORS_NUMBER:
            return TString("ERRORS_NUMBER");
    }
}

class IProcessingErrorListener {
public:
    virtual ~IProcessingErrorListener() = default;

    virtual void InvalidMetric(EInvalidMetricReason invalidMetricReason) = 0;

    virtual TString GetMessage() const = 0;
};

} // namespace NSolomon::NIngestor
