#include "metric_processor.h"
#include "shard.h"

#include <library/cpp/monlib/encode/json/json.h>
#include <library/cpp/monlib/encode/spack/spack_v1.h>

#include <util/stream/mem.h>

using NMonitoring::EFormat;

namespace NSolomon::NIngestor {

void TShard::UpdateConfig(const TShardConfig& config) {
    Config_ = config;
}

NThreading::TFuture<TDataProcessor::TProcessingResult> TShard::ProcessData(
        std::vector<std::unique_ptr<TShardData>> data,
        TInstant intervalStart,
        TDuration intervalLength)
{
    return Processor_.ProcessBatch(std::move(data), intervalStart, intervalLength);
}

NThreading::TFuture<TDataProcessor::TProcessingResult> TShard::ProcessAggregates(
        TInstant intervalStart,
        TDuration intervalLength)
{
    return Processor_.ProcessAggregates(intervalStart, intervalLength);
}

} // namespace NSolomon::NIngestor
