#include <solomon/services/ingestor/lib/shard/aggregation_state.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NIngestor;

TEST(TAggrStateTest, Simple) {
    TAggrState aggrState({});
    auto aggrs = aggrState.ReleaseAggregates();
    ASSERT_TRUE(aggrs.empty());
}

TEST(TAggrStateTest, SeqUpdates) {
    NMonitoring::TLabels labels{{"name", "value"}};
    TAggrState aggrState({});
    TVector<double> values{0.0, -1.0, 1.0, 0.0};
    NMonitoring::EMetricType type = NMonitoring::EMetricType::GAUGE;
    for (auto value: values) {
        aggrState.Collect(labels, type, value);
    }
    auto aggregates = aggrState.ReleaseAggregates();
    ASSERT_EQ(aggregates.size(), 1u);
    ASSERT_EQ(aggregates[0].Labels, labels);
    ASSERT_EQ(aggregates[0].MetricType, type);

    auto expected = NMonitoring::TSummaryDoubleSnapshot(0.0, -1.0, 1.0, 0.0, 4);
    auto actual = *dynamic_cast<NMonitoring::TSummaryDoubleSnapshot*>(aggregates[0].Aggregate.Get());
    ASSERT_EQ(actual.GetSum(), expected.GetSum());
    ASSERT_EQ(actual.GetMin(), expected.GetMin());
    ASSERT_EQ(actual.GetMax(), expected.GetMax());
    ASSERT_EQ(actual.GetLast(), expected.GetLast());
    ASSERT_EQ(actual.GetCount(), expected.GetCount());
}
