LIBRARY(solomon-ingestor-core)

OWNER(
    g:solomon
)

PEERDIR(
    solomon/libs/cpp/exception
    solomon/libs/cpp/glob
    solomon/libs/cpp/intern
    solomon/libs/cpp/labels
    solomon/libs/cpp/log_writer
    solomon/libs/cpp/slog
    solomon/libs/cpp/sync
    solomon/libs/cpp/timeseries
    solomon/libs/cpp/yasm/constants
    solomon/protos/common

    solomon/services/ingestor/config
    solomon/services/ingestor/lib/shard_config
    solomon/services/ingestor/lib/type_utils

    infra/yasm/common/points/hgram/ugram/compress

    library/cpp/containers/absl_flat_hash
    library/cpp/monlib/encode
    library/cpp/monlib/encode/json
    library/cpp/monlib/encode/prometheus
    library/cpp/monlib/encode/spack
    library/cpp/monlib/metrics
    library/cpp/regex/pire
    library/cpp/threading/atomic_shared_ptr
    library/cpp/threading/future

    library/cpp/yaml/as
)

SRCS(
    yasm_aggregator.cpp
    data_processor.cpp
    metric_processor.cpp
    yasm_metric_transformer.cpp
    metric_transformer.cpp
    shard.cpp
    labels.cpp
)

RESOURCE(
    rules.conf /rules.conf
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(validation_modes.h)

END()

RECURSE_FOR_TESTS(
    ut
)
