#include "yasm_metric_transformer.h"

using namespace NSolomon::NIntern;

namespace NSolomon::NIngestor {

TVector<TYasmAggrRule> GetYasmAggrRulesForProject(
        const TString& rulesConfig,
        const TString& project,
        TLabelPool& pool)
{
    YAML::Node yamlRules = YAML::Load(static_cast<std::string>(TStringBuf(rulesConfig.Data(), rulesConfig.Size())));
    auto aggregationRulesRaw = yamlRules["aggregation_rules"];
    auto customRules = aggregationRulesRaw["custom"];
    TString itype = TString("itype=") + project;
    TVector<TYasmAggrRule> result;
    for (auto part: customRules) {
        if (part["request_key"].as<TString>() == itype) {
            TYasmAggrRule rule;
            for (YAML::Node tag: part["tags"]) {
                rule.emplace_back(pool.Intern(tag.as<TString>()));
            }
            result.emplace_back(std::move(rule));
        }
    }

    if (result.empty()) {
        for (auto part: aggregationRulesRaw["default"]) {
            TYasmAggrRule rule;
            for (YAML::Node tag : part["tags"]) {
                rule.emplace_back(pool.Intern(tag.as<TString>()));
            }
            result.emplace_back(std::move(rule));
        }
    }

    std::sort(result.begin(), result.end());
    auto last = std::unique(result.begin(), result.end());
    result.erase(last, result.end());
    return result;
}

}; // namespace NSolomon::NIngestor
