#pragma once

#include "labels.h"

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/resource/resource.h>
#include <library/cpp/yaml/as/tstring.h>

#include <solomon/libs/cpp/intern/str_pool.h>

#include <unordered_set>
#include <algorithm>

namespace NSolomon::NIngestor {

using TYasmTeg = NIntern::TStringId;
using TYasmAggrRule = TVector<TYasmTeg>;

using TLabelsSet = std::unordered_set<TLabels>;

TVector<TYasmAggrRule> GetYasmAggrRulesForProject(
        const TString& rulesConfig,
        const TString& project,
        TLabelPool& pool);

class TYasmMetricTransformer {
public:
    explicit TYasmMetricTransformer(TVector<TYasmAggrRule> rules)
        : Rules_(std::move(rules))
    {
        CalcSizeBytes();
    }

    TLabelsSet Transform(const TLabels& labels) {
        TLabelsSet res;

        for (const auto& rule: Rules_) {
            TLabels transformed = Transform(labels, rule);
            if (!transformed.empty()) {
                res.emplace(std::move(transformed));
            }
        }

        return res;
    }

    void CalcSizeBytes() {
        SizeBytes_ = sizeof(*this);
        for (const auto& rule: Rules_) {
            SizeBytes_ += rule.capacity() * sizeof(TYasmTeg);
        }
        SizeBytes_ += (Rules_.capacity() - Rules_.size()) * sizeof(TYasmAggrRule);
    }

    size_t SizeBytes() const {
        Y_VERIFY(SizeBytes_ < (1l << 34));
        return SizeBytes_;
    }

private:
    size_t SizeBytes_ = sizeof(*this);
    TVector<TYasmAggrRule> Rules_;

    static TLabels Transform(TLabels labels, const TYasmAggrRule& rule) {
        bool transformed = false;

        for (auto& [name, value]: labels) {
            for (auto tag: rule) {
                if (name == tag && value != labels.LabelPool()->AggrIntTag) {
                    transformed = true;
                    value = labels.LabelPool()->AggrIntTag;
                }
            }
        }

        if (!transformed) {
            return TLabels(labels.LabelPool());
        }

        std::sort(labels.begin(), labels.end());

        return labels;
    }
};

}; // namespace NSolomon::NIngestor
