#pragma once

#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon::NIngestor {

class TShardMetrics {
public:
    TShardMetrics(TStringBuf shard, NMonitoring::IMetricRegistry* registry) {
        if (registry) {
            Metrics_ = registry->Rate(NMonitoring::MakeLabels({{"sensor", "processing.metrics.rate"}, {"shardId", shard}}));
            InputBytes_ = registry->Rate(NMonitoring::MakeLabels({{"sensor", "processing.inputBytes.rate"}, {"shardId", shard}}));
            OutputBytes_ = registry->Rate(NMonitoring::MakeLabels({{"sensor", "processing.outputBytes.rate"}, {"shardId", shard}}));

            MetricsTotal_ = registry->Rate(NMonitoring::MakeLabels({{"sensor", "processing.metrics.rate"}, {"shardId", "total"}}));
            InputBytesTotal_ = registry->Rate(NMonitoring::MakeLabels({{"sensor", "processing.inputBytes.rate"}, {"shardId", "total"}}));
            OutputBytesTotal_ = registry->Rate(NMonitoring::MakeLabels({{"sensor", "processing.outputBytes.rate"}, {"shardId", "total"}}));
        }
    }

    void IncMetrics(size_t inc) {
        if (Metrics_) {
            Metrics_->Add(inc);
            MetricsTotal_->Add(inc);
        }
    }

    void IncInputBytes(size_t inc) {
        if (InputBytes_) {
            InputBytes_->Add(inc);
            InputBytesTotal_->Add(inc);
        }
    }

    void IncOutputBytes(size_t inc) {
        if (OutputBytes_) {
            OutputBytes_->Add(inc);
            OutputBytesTotal_->Add(inc);
        }
    }

private:
    NMonitoring::IRate* Metrics_{nullptr};
    NMonitoring::IRate* InputBytes_{nullptr};
    NMonitoring::IRate* OutputBytes_{nullptr};

    NMonitoring::IRate* MetricsTotal_{nullptr};
    NMonitoring::IRate* InputBytesTotal_{nullptr};
    NMonitoring::IRate* OutputBytesTotal_{nullptr};
};

} // namespace NSolomon::NIngestor
