#pragma once

#include <solomon/services/ingestor/api/ingestor_grpc_service.pb.h>
#include <solomon/services/ingestor/lib/events/events.h>
#include <solomon/services/ingestor/lib/shard/data_processor.h>
#include <solomon/services/ingestor/lib/shard/shard.h>
#include <solomon/services/ingestor/lib/shard_config/shard_config.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/clients/memstore/rpc.h>
#include <solomon/libs/cpp/metering/shard_metrics_repo.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/actorid.h>
#include <library/cpp/actors/core/event_local.h>

#include <util/generic/fwd.h>

namespace NSolomon::NIngestor {
    struct TShardActorEvents: private TEventSlot<EEventSpace::Ingestor, IS_SHARD_ACTOR> {
        enum {
            ProcessData = SpaceBegin,
            ProcessingResult,
            UpdateConfig,
            CalcSizeBytes,
            End,
        };

        static_assert(End < SpaceEnd, "too many event types");

        struct TProcessData: NActors::TEventLocal<TProcessData, ProcessData> {
            TProcessData(NActors::TActorId handlerId, ui32 numId) noexcept
                : HandlerId{handlerId}
                , NumId{numId}
            {
            }

            NActors::TActorId HandlerId;
            ui32 NumId;
            std::vector<std::unique_ptr<TShardData>> Data;
        };

        struct TProcessingResult: NActors::TEventLocal<TProcessingResult, ProcessingResult> {
            explicit TProcessingResult(ui32 numId) noexcept
                : NumId{numId}
            {
            }

            ui32 NumId;
            std::vector<TProcessingStatus> Statuses;
        };

        struct TUpdateConfig: NActors::TEventLocal<TUpdateConfig, UpdateConfig> {
            explicit TUpdateConfig(TShardConfig config)
                : Config(std::move(config))
            {
            }

            TShardConfig Config;
        };

        struct TCalcSizeBytes: NActors::TEventLocal<TCalcSizeBytes, CalcSizeBytes>{
        };
    };

    NActors::IActor* CreateShardActor(
        TShardConfig shardConfig,
        IThreadPool* processorsExecutor,
        std::shared_ptr<IClusterRpc<NMemStore::IMemStoreRpc>> memStoreRpc,
        NActors::TActorId memStoreClusterWatcher,
        std::shared_ptr<TShardMeteringMetricsRepository> meteringMetricsRepo,
        const TString& yasmPrefix,
        NMonitoring::IMetricRegistry* registry = nullptr);
}
