#pragma once

#include <atomic>
#include <functional>

namespace NSolomon::NIngestor {

class TTasksCounter {
public:
    TTasksCounter(std::function<void()> callback, bool waitFinish)
        : Callback_(std::move(callback))
        , WaitFinish_(waitFinish)
    {
        TasksCounter_.store(0, std::memory_order_relaxed);
    }

    void OnStart() {
        TasksCounter_.fetch_add(1u);
    }

    void SetWait() {
        OnStart();
        WaitFinish_.store(true);
        return OnFinish();
    }

    void OnFinish() {
        if (TasksCounter_.fetch_sub(1u) == 1) {
            if (WaitFinish_.exchange(false)) {
                Callback_();
            }
        }
    }

private:
    std::function<void()> Callback_;
    std::atomic<size_t> TasksCounter_;
    std::atomic<bool> WaitFinish_;
};

} // namespace NSolomon::NIngestor
