#pragma once

#include <solomon/libs/cpp/conf_db/model/service_config.h>
#include <solomon/libs/cpp/conf_db/model/shard_config.h>
#include <solomon/libs/cpp/shard_key/shard_key.h>

#include <util/generic/fwd.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSolomon::NIngestor {
    using TSourceId = ui64;

    using TShardId = ui32;
    using TAggrRuleItem = NSolomon::NDb::NModel::TMetricConf::TAggrRuleItem;

    struct TShardConfig {
        TString ShardStrId;
        TShardId ShardNumId;
        TString ServiceId;
        TString ClusterId;
        // key contains service and cluster names, do not confuse with above ids
        TShardKey Key;

        bool IsShardMemOnly;
        TVector<TAggrRuleItem> AggrRules;
        TString MetricNameLabel;
        TDuration Interval;

        void CalculateSizeBytes() {
            SizeBytes_ = sizeof(*this);
            SizeBytes_ += ShardStrId.capacity();
            SizeBytes_ += ServiceId.capacity();
            SizeBytes_ += ClusterId.capacity();
            SizeBytes_ += Key.ServiceName.capacity();
            SizeBytes_ += Key.ClusterName.capacity();
            SizeBytes_ += Key.ProjectId.capacity();
            for (const auto& aggrRule: AggrRules) {
                for (const auto& cond: aggrRule.Cond) {
                    SizeBytes_ += cond.capacity();
                }
                for (const auto& target: aggrRule.Target) {
                    SizeBytes_ += target.capacity();
                }
                SizeBytes_ += (aggrRule.Cond.capacity() - aggrRule.Cond.size()) * sizeof(TString);
                SizeBytes_ += (aggrRule.Target.capacity() - aggrRule.Target.size()) * sizeof(TString);
            }
            SizeBytes_ += (AggrRules.capacity() - AggrRules.size()) * sizeof(TAggrRuleItem);
            SizeBytes_ += MetricNameLabel.capacity();
        }

        size_t SizeBytes() const {
            Y_VERIFY(SizeBytes_ < (1l << 34));
            return SizeBytes_;
        }

    private:
        size_t SizeBytes_ = sizeof(*this);
    };
} // namespace NSolomon::NIngestor
