#pragma once

#include "create_shard_opts.h"

#include <solomon/services/ingestor/lib/shard_config/shard_config.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/conf_db/db.h>
#include <solomon/libs/cpp/id_validator/validator.h>
#include <solomon/libs/cpp/shard_key/shard_key.h>

namespace NSolomon::NIngestor {
    class TShardAssigner;
    class INumIdGenerator {
    public:
        virtual ~INumIdGenerator() = default;
        virtual TShardId Generate() const = 0;
    };

    struct TShardCreationContext {
        TCreateShardOpts Opts;
        TString User;
        IIdValidator* IdValidator{nullptr};
        const INumIdGenerator* NumIdGenerator{nullptr};
        const TShardAssigner* Assigner;

        NSolomon::NDb::IShardConfigDaoPtr ShardDao;
        NSolomon::NDb::IServiceConfigDaoPtr ServiceDao;
        NSolomon::NDb::IClusterConfigDaoPtr ClusterDao;
        NSolomon::NDb::IProjectConfigDaoPtr ProjectDao;
    };

    NActors::IActor* CreateShard(NActors::TActorId clientId, ui64 cookie,  TShardKey key, TShardCreationContext ctx);

} // namespace NSolomon::NIngestor
