#include "shard_config_page.h"

#include <util/string/vector.h>

namespace NSolomon::NIngestor {

yandex::monitoring::selfmon::Page ShardConfigPage(const TShardConfig& conf) {
    yandex::monitoring::selfmon::Page page;
    page.set_title("Shard " + conf.ShardStrId);

    auto* grid = page.mutable_grid();
    if (auto* r = grid->add_rows()) {
        auto* obj = r->add_columns()->mutable_component()->mutable_object();
        if (auto* f = obj->add_fields()) {
            f->set_name("NumId");
            f->mutable_value()->set_uint32(conf.ShardNumId);
        }
        if (auto* f = obj->add_fields()) {
            f->set_name("StrId");
            f->mutable_value()->set_string(conf.ShardStrId);
        }

        if (auto* f = obj->add_fields()) {
            f->set_name("Key");
            f->mutable_value()->set_string(ToString(conf.Key));
        }

        if (auto* f = obj->add_fields()) {
            f->set_name("ServiceId");
            f->mutable_value()->set_string(conf.ServiceId);
        }
        if (auto* f = obj->add_fields()) {
            f->set_name("ClusterId");
            f->mutable_value()->set_string(conf.ClusterId);
        }
        if (auto* f = obj->add_fields()) {
            f->set_name("MetricNameLabel");
            f->mutable_value()->set_string(conf.MetricNameLabel);
        }
        if (auto* f = obj->add_fields()) {
            f->set_name("Interval");
            f->mutable_value()->set_duration(conf.Interval.GetValue());
        }
        if (auto* f = obj->add_fields()) {
            f->set_name("IsMemOnly");
            f->mutable_value()->set_boolean(conf.IsShardMemOnly);
        }
    }

    if (auto* r = grid->add_rows()) {
        auto* h = r->add_columns()->mutable_component()->mutable_heading();
        h->set_content("Aggregation Rules");
        h->set_level(3);
    }
    if (auto* r = grid->add_rows()) {
        auto* t = r->add_columns()->mutable_component()->mutable_table();
        t->set_numbered(true);

        auto* condColumn = t->add_columns();
        condColumn->set_title("Condition");
        auto* condValues = condColumn->mutable_string();

        auto* targetColumn = t->add_columns();
        targetColumn->set_title("Target");
        auto* targetValues = targetColumn->mutable_string();

        for (const auto& rule : conf.AggrRules) {
            condValues->add_values(JoinStrings(rule.Cond, ", "));
            targetValues->add_values(JoinStrings(rule.Target, ", "));
        }
    }

    return page;
}

} // namespace NSolomon::NIngestor
