#include "pool.h"

namespace NSolomon::NIngestor {
namespace {

class TStatusListenerWithMetering: public IThreadPoolStatusListener  {
public:
    TStatusListenerWithMetering(
            std::shared_ptr<IResourceUsageContext> shardMeteringContext)
        : ShardMeteringContext_{std::move(shardMeteringContext)}
    {}

private:
    void OnStart(size_t, size_t) noexcept override {
    }

    void OnTaskScheduled() noexcept override {
    }

    void OnTaskRejected() noexcept override {
    }

    void OnTaskBeforeExecution(TDuration) noexcept override {
    }

    void OnTaskCompleted(TDuration execTime) noexcept override {
        if (ShardMeteringContext_) {
            ShardMeteringContext_->AddCpuTime(execTime);
        }
    }

    void OnStop() noexcept override {
    }

private:
    std::shared_ptr<IResourceUsageContext> ShardMeteringContext_;
};

} // namespace

std::shared_ptr<IThreadPool> CreateThreadPoolProxyWithMetering(
        IThreadPool* pool,
        std::shared_ptr<IResourceUsageContext> shardMeteringContext)
{
    return NSolomon::CreateThreadPoolProxy(
            pool,
            std::make_shared<TStatusListenerWithMetering>(std::move(shardMeteringContext)));
}

} // namespace NSolomon::NIngestor
