#include "histogram_utils.h"

#include <solomon/services/ingestor/lib/type_utils/doubles_out.h>

#include <solomon/libs/cpp/math/math.h>

#include <library/cpp/monlib/metrics/labels.h>

#include <cmath>

using NMonitoring::EMetricType;
using NMonitoring::IHistogramSnapshotPtr;
using NMonitoring::TLabel;

namespace NSolomon::NIngestor::NHistogramUtils {

const TString LABEL_INF = "inf";
const TString LABEL_BIN = "bin";

TLabel BoundToLabel(double bound/* TODO:, LabelAllocator labelAllocator*/) {
    Y_ENSURE(!std::isnan(bound), "a histogram bound cannot be NaN");
    Y_ENSURE(!std::isinf(bound), "a histogram bound cannot be inf");

    TString binValue = AreDoublesEqual(bound, NMonitoring::HISTOGRAM_INF_BOUND)
            ? LABEL_INF
            : DoubleToString(bound);
    // TODO:
    // return labelAllocator.alloc(LabelKeys.BIN, binValue);
    return {LABEL_BIN, binValue};
}

// TODO: a place for an optimization: all labels have the same key "bin="
TBinLabelToValue SplitBuckets(const IHistogramSnapshotPtr& snapshot/*TODO:, LabelAllocator labelAllocator*/) {
    TBinLabelToValue result;

    for (size_t i = 0; i < snapshot->Count(); i++) {
        auto upperBound = snapshot->UpperBound(i);
        TLabel binLabel = BoundToLabel(upperBound/*TODO:, labelAllocator*/);

        result[binLabel] = snapshot->Value(i);
    }

    return result;
}

//Map<Label, TimeSeries> splitBuckets(TimeSeries timeSeries, LabelAllocator labelAllocator) {
//    Double2ObjectOpenHashMap <TimeSeries> bucketTimeSeries = new Double2ObjectOpenHashMap<>();
//
//    for (int index = 0; index < timeSeries.size(); index++) {
//        final long ts = timeSeries.tsMillisAt(index);
//        final
//        HistogramSnapshot snapshot = timeSeries.histogramAt(index);
//        for (int bucketIndex = 0; bucketIndex < snapshot.count(); bucketIndex++) {
//            double bound = snapshot.upperBound(bucketIndex);
//            long value = snapshot.value(bucketIndex);
//            TimeSeries bucketTs = bucketTimeSeries.get(bound);
//            if (bucketTs == null) {
//                bucketTs = TimeSeries.newLong(timeSeries.size());
//            }
//            bucketTs = bucketTs.addLong(ts, value);
//            bucketTimeSeries.put(bound, bucketTs);
//        }
//    }
//
//    return bucketTimeSeries.double2ObjectEntrySet()
//            .stream()
//            .collect(Collectors.toMap(
//                    e->BoundToLabel(e.getDoubleKey(), labelAllocator),
//                    Map.Entry::getValue));
//}

EMetricType HistogramBucketKind(EMetricType kind) {
    return (kind == EMetricType::HIST_RATE) ? EMetricType::RATE : EMetricType::IGAUGE;
}

} // namespace NSolomon::NIngestor::NHistogramUtils
