#include <solomon/services/ingestor/lib/type_utils/doubles_out.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace NSolomon::NIngestor {

#define CHECK_NUMBER(NUM) ASSERT_EQ(DoubleToString(double(NUM)), #NUM)

TEST(TDoublesTest, DoubleToString) {
    /** Checks the longest bin labels found, constructed by Coremon.
     *  Labels are gathered from https://nda.ya.ru/t/azbASUI03Vuc4B
     */

    CHECK_NUMBER(3.0000000000000003E-4);
    CHECK_NUMBER(8.000000000000001E-4);
    CHECK_NUMBER(6.000000000000001E-4);
    CHECK_NUMBER(7.000000000000001E-4);
    CHECK_NUMBER(9.000000000000002E-4);
    CHECK_NUMBER(1.1062161721765945E7);
    CHECK_NUMBER(0.060000000000000005);
    CHECK_NUMBER(0.009000000000000001);
    CHECK_NUMBER(0.30000000000000004);
    CHECK_NUMBER(1871914.2928141265);
    CHECK_NUMBER(43.950285691470945);
    CHECK_NUMBER(349.22721931736396);
    CHECK_NUMBER(0.7999999999999999);
    CHECK_NUMBER(16398.665695107135);
    CHECK_NUMBER(2.4651899999999998);
    CHECK_NUMBER(18.079427788379103);
    CHECK_NUMBER(2.5060000000000002);
    CHECK_NUMBER(1534.8636060236126);
    CHECK_NUMBER(30.009999999999998);
    CHECK_NUMBER(193.16276123619156);
    CHECK_NUMBER(29647.849226045902);
    CHECK_NUMBER(316761.15462561045);
    CHECK_NUMBER(20.009999999999998);
    CHECK_NUMBER(1392174.3241755778);
    CHECK_NUMBER(24.309555703815377);
    CHECK_NUMBER(235580.62890958073);
    CHECK_NUMBER(21.372109000000002);
    CHECK_NUMBER(130303.14436223732);
    CHECK_NUMBER(106.84119182154129);
    CHECK_NUMBER(259.72619040477815);
    CHECK_NUMBER(1035383.5943952468);
    CHECK_NUMBER(1.2621769999999999);
    CHECK_NUMBER(1.6480000000000001);
    CHECK_NUMBER(0.8999999999999999);
    CHECK_NUMBER(12195.965071213825);
    CHECK_NUMBER(7.0009999999999994);
    CHECK_NUMBER(4.0009999999999994);
    CHECK_NUMBER(5.0009999999999994);
    CHECK_NUMBER(6.0009999999999994);
    CHECK_NUMBER(22049.60698146041);
    CHECK_NUMBER(72072.60422588825);
    CHECK_NUMBER(143.6584130011693);
    CHECK_NUMBER(2063.773962601452);
    CHECK_NUMBER(9070.345525895287);
    CHECK_NUMBER(1141.504026984738);
    CHECK_NUMBER(96908.65262198373);
    CHECK_NUMBER(32.68657091552145);
    CHECK_NUMBER(572686.0421217311);
    CHECK_NUMBER(2774.945573011506);
    CHECK_NUMBER(770032.2933176152);
    CHECK_NUMBER(3384313.928296773);
    CHECK_NUMBER(39864.42771834531);
    CHECK_NUMBER(3731.185232838995);
    CHECK_NUMBER(425916.2968711699);
    CHECK_NUMBER(6118645.927984713);
    CHECK_NUMBER(6745.769398217908);
    CHECK_NUMBER(631.3828293384713);
    CHECK_NUMBER(70.00999999999999);
    CHECK_NUMBER(4550540.477393317);
    CHECK_NUMBER(79.45960164375802);
    CHECK_NUMBER(8227116.795912865);
    CHECK_NUMBER(59.09544985169027);
    CHECK_NUMBER(469.5700904173988);
    CHECK_NUMBER(5016.942810394379);
    CHECK_NUMBER(848.9558541284008);
    CHECK_NUMBER(53601.61491630482);
    CHECK_NUMBER(80.00999999999999);
    CHECK_NUMBER(2516971.516276784);
    CHECK_NUMBER(175205.298714827);
    CHECK_NUMBER(562949953421312);
    CHECK_NUMBER(140737488355328);
    CHECK_NUMBER(281474976710656);
    CHECK_NUMBER(10000000000000);
    CHECK_NUMBER(70368744177664);
    CHECK_NUMBER(35184372088832);
    CHECK_NUMBER(17592186044416);
    CHECK_NUMBER(13.44597627113);
    CHECK_NUMBER(1000000000000);
    CHECK_NUMBER(5336797740815);
    CHECK_NUMBER(2199023255552);
    CHECK_NUMBER(1099511627776);
    CHECK_NUMBER(4398046511104);
    CHECK_NUMBER(8796093022208);
    CHECK_NUMBER(549755813888);
    CHECK_NUMBER(100000000000);
    CHECK_NUMBER(777203554488);
    CHECK_NUMBER(274877906944);
    CHECK_NUMBER(137438953472);
    CHECK_NUMBER(113184983663);
    CHECK_NUMBER(14078.78849);
    CHECK_NUMBER(0.066211593);
    CHECK_NUMBER(2509.483752);
    CHECK_NUMBER(0.407385854);
    CHECK_NUMBER(251.7347628);
    CHECK_NUMBER(0.014231736);
    CHECK_NUMBER(2184.164409);
    CHECK_NUMBER(0.012375423);
    CHECK_NUMBER(0.010761238);
    CHECK_NUMBER(0.002011355);
    CHECK_NUMBER(25.25236148);
}

} // namespace NSolomon::NIngestor
