#include <solomon/services/memstore/api/memstore_service.pb.h>
#include <solomon/services/memstore/lib/index/shard_manager.h>

#include <solomon/libs/cpp/grpc/server/handler.h>

using namespace NActors;

using yandex::monitoring::memstore::ListShardsRequest;
using yandex::monitoring::memstore::ListShardsResponse;

namespace NSolomon::NMemStore::NApi {
namespace {

class TListShardsHandler: public NGrpc::TBaseHandler<TListShardsHandler> {
public:
    explicit TListShardsHandler(NActors::TActorId shardManager) noexcept
        : ShardManager_(shardManager)
    {
    }

public:
    STATEFN(HandleEvent) {
        switch (ev->GetTypeRewrite()) {
            hFunc(NIndex::TShardManagerEvents::TListShardsResponse, OnListShardsResponse);
        }
    }

    EMode HandleRequest(NGrpc::TRequestState* req) {
        auto* msg = req->GetMessage<ListShardsRequest>();
        Send(ShardManager_, new NIndex::TShardManagerEvents::TListShards{msg->generation()}, 0, req->ToCookie());
        return EMode::Async;
    }

    void OnListShardsResponse(NIndex::TShardManagerEvents::TListShardsResponse::TPtr& ev) {
        if (auto req = NGrpc::TRequestState::FromCookie(ev->Cookie); !req->IsReplied()) {
            auto* resp = google::protobuf::Arena::CreateMessage<ListShardsResponse>(req->Arena());
            resp->set_generation(ev->Get()->Generation);
            for (auto& [numId, shardKey]: ev->Get()->Shards) {
                resp->add_num_ids(numId);
                auto* key = resp->add_shard_keys();
                key->set_project(std::move(shardKey.ProjectId));
                key->set_cluster(std::move(shardKey.ClusterName));
                key->set_service(std::move(shardKey.ServiceName));
            }
            req->SendReply(resp);
        }
    }

private:
    NActors::TActorId ShardManager_;
};

} // namespace

IActor* CreateListShardsHandler(TActorId shardManager) {
    return new TListShardsHandler{shardManager};
}

} // namespace NSolomon::NMemStore::NApi
